<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerWalletResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $supplier = $this->relationLoaded('supplier') ? $this->whenLoaded('supplier') : null;
        $salesman = $this->relationLoaded('salesman') ? $this->whenLoaded('salesman') : null;
        $account_status = $this->relationLoaded('account_status') ? $this->whenLoaded('account_status') : null;
        $branchOffice = $this->relationLoaded('branchOffice') ? $this->whenLoaded('branchOffice') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'description' => $this->description,
            'idsupplier' => $this->idsupplier,
            $this->mergeWhen($supplier, fn() => [
                'rut_supplier' => $supplier->rut,
                'name_supplier' => $supplier->name_rz,
                'email_supplier' => $supplier->email,
                'phone_supplier' => $supplier->phone
            ]),
            'idsalesman' => $this->idsalesman,
            $this->mergeWhen($salesman, fn() => [
                'rut_salesman' => $salesman->rut,
                'name_salesman' => $salesman->name,
                'surname_salesman' => $salesman->surname,
                'email_salesman' => $salesman->email,
                'phone_salesman' => $salesman->phone,
                'address_salesman' => $salesman->address,
                'idchannel_salesman' => $salesman->idchannel
            ]),
            'idaccount_status' => $this->idaccount_status,
            $this->mergeWhen($account_status, fn() => [
                'account_status' => $account_status->name
            ]),
            'relationship_date' => $this->relationship_date,
            'last_purchase' => $this->last_purchase,
            'goal' => $this->goal,
            'idbranchoffice' => $this->idbranchoffice,
            $this->mergeWhen($branchOffice, fn() => [
                'branchOffice' => $branchOffice->name,
                'assignmenttype' => $branchOffice->assignmenttype,
                'idproductlist' => $branchOffice->idproductlist,
                'idofficetype' => $branchOffice->idofficetype,
                'officetype' => $branchOffice->typeOffice->name,
                'iddistrict' => $branchOffice->iddistrict,
                'district' => $branchOffice->district->name,
                'idprovince' => $branchOffice->idprovince,
                'province' => $branchOffice->province->name,
                'iddepartment' => $branchOffice->iddepartment,
                'department' => $branchOffice->department->name,
                'idcountry' => $branchOffice->idcountry,
                'country' => $branchOffice->country->name
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
