<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $membership = $this->relationLoaded('membership') ? $this->whenLoaded('membership') : null;

        return [
            'id'            => $this->id,
            'rut'           => $this->rut,
            'business_name' => $this->business_name,
            'address'       => $this->address,
            'email'         => $this->email,
            'phone'         => $this->phone,
            'idmembership'  => $this->idmembership,
            $this->mergeWhen($membership, fn() => [
                'membership_name'   => $membership->name
            ]),
            'status'        => $this->status
        ];
    }
}
