<?php

namespace App\Http\Resources;

use App\Models\Permissions;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyDefaultPermissionsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $userType = $this->relationLoaded('userType') ? $this->whenLoaded('userType') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'                    => $this->id,
            'idcompany'             => $this->idcompany,
            $this->mergeWhen($company, fn () => [
                'company'           => $company->business_name,
                'rut_company'       => $company->rut
            ]),
            'iduser_type'           => $this->iduser_type,
            $this->mergeWhen($userType, fn () => [
                'user_type_name'    => $userType->name,
            ]),
            'permissions'           => $this->permissions,
            'detail_permissions'    => Permissions::whereIn('id', $this->permissions)->get(),
            'status'                => $this->status
        ];
    }
}
