<?php

namespace App\Http\Resources;

use App\Models\CashPaymentMethods;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyConfigurationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'                        => $this->id,
            'idcompany'                 => $this->idcompany,
            'inventory_configuration'   => $this->inventory_configuration,
            'credit_terms'              => $this->credit_terms,
            'cash_options'              => CashPaymentMethods::whereIn('id', $this->cash_options)->get(),
            'payment_validation'        => $this->payment_validation,
            'payment_validation_name'   => 'Verificación de pago '. ($this->payment_validation == 1 ? 'requerido': 'no requerido'),
            'status'                    => $this->status
        ];
    }
}
