<?php

namespace App\Http\Resources;

use App\Models\SupplierContact;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientAddressResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $department = $this->relationLoaded('department') ? $this->whenLoaded('department') : null;
        $province = $this->relationLoaded('province') ? $this->whenLoaded('province') : null;
        $district = $this->relationLoaded('district') ? $this->whenLoaded('district') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'address' => $this->address,
            'email' => $this->email,          
            $this->mergeWhen($country, fn() => [
                'idcountry' => $country->id,
                'country' => $country->name
            ]),
            $this->mergeWhen($department, fn() => [
                'iddepartment' => $department->id,
                'department' => $department->name
            ]),
            $this->mergeWhen($province, fn() => [
                'idprovince' => $province->id,
                'province' => $province->name
            ]),
            $this->mergeWhen($district, fn() => [
                'iddistrict' => $district->id,
                'district' => $district->name
            ]),
            $this->mergeWhen($company, fn() => [
                'idcompany' => $company->id,
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
