<?php

namespace App\Http\Resources;

use App\Models\Subcategory;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $idsubcategories = json_decode($this->idsubcategories) ?? [];
        $subcategories = count($idsubcategories) > 0 ? Subcategory::whereIn('id', $idsubcategories)->active()->company()->get() : [];

        return [
            'id'                => $this->id,
            'name'              => $this->name,
            'description'       => $this->description,
            'quantity_products' => $this->quantity_products,
            'idsubcategories'   => $idsubcategories,
            'idcompany'         => $this->idcompany,
            'status'            => $this->status,
            'subcategories'     => $subcategories
        ];
    }
}
