<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BusinessAreaResource extends JsonResource
{
    
    public function toArray(Request $request): array
    {
        $branchOffice = $this->relationLoaded('branchOffice') ? $this->whenLoaded('branchOffice') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'=>$this->id,
            'name' => $this->name,
            'description' => $this->description,
            'iderp' => $this->iderp,
            'idbranchoffice' => $this->idbranchoffice,
            $this->mergeWhen($branchOffice, fn() => [
                'branchoffice' => $branchOffice->name,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
