<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BranchOfficeResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $typeOffice = $this->relationLoaded('typeOffice') ? $this->whenLoaded('typeOffice') : null;
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $department = $this->relationLoaded('department') ? $this->whenLoaded('department') : null;
        $province = $this->relationLoaded('province') ? $this->whenLoaded('province') : null;
        $district = $this->relationLoaded('district') ? $this->whenLoaded('district') : null;
        // $productList = $this->relationLoaded('productList') ? $this->whenLoaded('productList') : null;

        return [
            'id'=>$this->id,
            'code'=>$this->code,
            'name' => $this->name,
            'phone' => $this->phone,
            'address' => $this->address,
            // 'assignmenttype' => $this->assignmenttype,
            // 'assignmentname' => $this->assignmenttype && $this->assignmenttype == '1' ? 'Sucursal' : 'Usuario',
            // 'idproductlist' => $this->idproductlist,
            // $this->mergeWhen($productList, fn() => [
            //     'productlist' => $productList->name,
            // ]),
            'idofficetype' => $this->idofficetype,
            $this->mergeWhen($typeOffice, fn() => [
                'typeOffice' => $typeOffice->name,
            ]),
            'idcountry' => $this->idcountry,
            $this->mergeWhen($country, fn() => [
                'country' => $country->name,
            ]),
            'iddepartment' => $this->iddepartment,
            $this->mergeWhen($department, fn() => [
                'department' => $department->name,
            ]),
            'idprovince' => $this->idprovince,
            $this->mergeWhen($province, fn() => [
                'province' => $province->name,
            ]),
            'iddistrict' => $this->iddistrict,
            $this->mergeWhen($province, fn() => [
                'district' => $district->name,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
