<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BankResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;

        return [
            'id'        => $this->id,
            'name'      => $this->name,
            'code_SBIF' => $this->code_SBIF,
            'idcountry' => $this->idcountry,
            $this->mergeWhen($country, fn() => [
                'country_name' => $country->name,
            ])
        ];
    }
}
