<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdminCompanyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'            => $this->id,
            'rut'           => $this->rut,
            'name'          => $this->name,
            'surname'       => $this->surname,
            'email'         => $this->email,
            'phone'         => $this->phone,
            'address'       => $this->address,
            'birthdate'     => $this->birthdate,
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
