<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class listProductRequest extends FormRequest
{
    use HasResponse;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'idsalesman'            => ['nullable','numeric', 'validate_ids_exist:Salesman'],
            'idcustomer'            => ['nullable','numeric', 'validate_ids_exist:Supplier'],
            'search'                => ['nullable','string'],
            'code'                  => ['nullable','string'],
            'modelo'                => ['nullable','string'],
            'marca'                => ['nullable','string'],
            'iduse'                 => ['nullable','numeric'],
            'idspecific_use'                 => ['nullable','numeric'],
            'idcategory_product'    => ['nullable','numeric', 'validate_ids_exist:Category'],
            'idsubcategory_product' => ['nullable','numeric', 'validate_ids_exist:Subcategory'],
            'idcompany'             => ['required', 'numeric', 'validate_ids_exist:Company'],
            'page'                  => ['nullable','numeric'],
            'perPage'               => ['nullable','numeric']
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
