<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class UserRequest extends FormRequest
{
    use HasResponse;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $rules = [
            'rut' => ['required','string','max:11'],
            'username' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'first_surname' => ['required', 'string', 'max:100'],
            'second_surname' => ['required', 'string', 'max:100'],
            'gender' => ['required', 'string', 'max:1'],
            'type_person' => ['required', 'numeric', 'max:1'],
            'idprivilege' => ['required', 'numeric'],
            'age' => ['required', 'numeric'],
            'birthdate' => ['required', 'string'],
            'email' => ['required','string','email'],
            'phone' => ['required', 'string', 'max:15'],
            'idcompany' => ['nullable', 'numeric'],
            'idcompanies' => ['nullable', 'string'],
            'iduser_type' => ['required', 'numeric'],
        ];

        if ($this->isMethod('POST')) {
            $rules['password'] = ['required','string','confirmed'];
        }

        return $rules;
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
