<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class TicketRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'idshopping_cart'   => ['required', 'numeric', 'validate_ids_exist:ShoppingCart'],
            'idtype_document'   => ['required', 'numeric', 'validate_ids_exist:DocumentOfSale'],
            'idsale_channel'       => ['nullable', 'numeric', 'validate_ids_exist:SaleChannel'],
            'idclient_address'   => ['nullable', 'numeric', 'validate_ids_exist:ClientAddress'],
            // 'payment_condition' => ['required', 'numeric'],
            'idway_to_pay'      => ['required', 'numeric', 'validate_ids_exist:WayToPay'],
            'folio'             => ['nullable', 'numeric', 'min:1'],
            'customer_rut'      => ['nullable', 'string'],
            'seller_rut'        => ['nullable', 'string'],
            'observation'       => ['required'],
            'bussines_area'     => ['required']
        ];
    }

    public function failedValidation(Validator $validator)
    {
        $errors = $validator->errors();
        $primerArray = reset($errors);
        $primerError = reset($primerArray);
        $message = $primerError[0];

        throw new HttpResponseException($this->errorResponse($message, 400));
    }
}
