<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreRequest extends FormRequest
{
    use HasResponse;
    
    public function authorize(): bool
    {
        return true;
    }

    
    public function rules(): array
    {
        return [
            'code' => ['required', 'string', 'max:11'],
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:255'],
            'address' => ['nullable', 'string', 'max:255'],
            'status' => ['nullable', 'string', 'max:1'],

            'idcountry' => ['nullable', 'numeric'],
            'iddepartment' => ['nullable', 'numeric'],
            'idprovince' => ['nullable', 'numeric'],
            'iddistrict' => ['nullable', 'numeric'],
            'idbranchoffice' => ['nullable', 'numeric', 'validate_ids_exist:BranchOffice'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
