<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class StockProductRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'stock_erp'             => ['required', 'numeric'],
            'stock_system'          => ['required', 'numeric'],
            'registration_date'     => ['required', 'date'],
            // 'last_update'           => ['required', 'date'],
            'idproduct'             => ['required', 'numeric', 'validate_ids_exist:Product'],
            'idwarehouse'           => ['required', 'numeric', 'validate_ids_exist:Store'],
            'idcompany'             => ['required', 'numeric', 'validate_ids_exist:Company']
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
