<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ShoppingCartRequest extends FormRequest
{
    use HasResponse;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'iduser_created' => ['required', 'numeric', 'validate_ids_exist:User'],
            'idcustomer' => ['nullable', 'numeric', 'validate_ids_exist:Supplier'],
            'idproduct' => ['required', 'numeric', 'validate_ids_exist:Product'],
            'quantity' => ['required', 'numeric'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
