<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class SalesmanBranchOfficeRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'idsalesman'        => ['required', 'numeric', 'validate_ids_exist:Salesman'],
            'idbranchoffice'    => ['required', 'numeric', 'validate_ids_exist:BranchOffice'],
            'idcompany'         => ['required', 'numeric', 'validate_ids_exist:Company']
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
