<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ReferenceDocumentsRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'folio' => ['required','string','max:20'],
            'description' => ['required', 'string'],
            'iddocument_of_sale' => ['required', 'numeric', 'validate_ids_exist:DocumentOfSale'],
            'idcustomer' => ['required', 'numeric', 'validate_ids_exist:Supplier'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
