<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ProductsImportRequest extends FormRequest
{
    use HasResponse;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'code' => ['required', 'string', 'max:100'],
            'barcode' => ['nullable', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:255'],
            'cost' => ['nullable', 'numeric'],
            'price' => ['nullable', 'numeric'],
            'alternativeprice' => ['nullable', 'numeric'],
            'margin' => ['nullable', 'numeric'],
            'offerprice' => ['nullable', 'numeric'],
            'minimumstock' => ['nullable', 'numeric'],
            'maximumstock' => ['nullable', 'numeric'],

            'main_image' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image1' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image2' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image3' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image4' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],

            'idattributes' => ['nullable', 'string'],
            'idspecificattributes' => ['nullable', 'string'],
            'iduses' => ['nullable', 'string'],
            'idspecificuses' => ['nullable', 'string'],
            'idwarehouses' => ['nullable', 'array'],

            'idcointype' => ['required', 'numeric', 'validate_ids_exist:CoinType'],
            'idcategory' => ['required', 'numeric', 'validate_ids_exist:Category'],
            'idsubcategory' => ['nullable', 'numeric', 'validate_ids_exist:Subcategory'],
            'idspecificsubcategory' => ['nullable', 'numeric', 'validate_ids_exist:SpecificSubcategory'],
            'idtype' => ['required', 'numeric', 'validate_ids_exist:TypeProduct'],
            'idsupplier' => ['required', 'numeric', 'validate_ids_exist:Supplier'],

            'idunitmeasure' => ['required', 'numeric', 'validate_ids_exist:UnitMeasure'],
            'idunitmeasureoptional' => ['nullable', 'numeric', 'validate_ids_exist:UnitMeasure'],
            'idbusinessarea' => ['nullable', 'numeric', 'validate_ids_exist:BusinessArea'],
            'idclassification' => ['required', 'numeric', 'validate_ids_exist:ProductClassification'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    // public function attributes()
    // {
    //     return [
    //         'code' => 'código',
    //         'barcode' => 'código de barras',
    //         'name' => 'nombre',
    //         'description' => 'descripción',
    //         'cost' => 'costo',
    //         'price' => 'precio',
    //         'alternativeprice' => 'precio alternativo',
    //         'margin' => 'margen',
    //         'offerprice' => 'precio de oferta',
    //         'minimumstock' => 'stock mínimo',
    //         'maximumstock' => 'stock máximo',

    //         'main_image' => 'imagen principal',
    //         'optional_image1' => 'imagen opcional 1',
    //         'optional_image2' => 'imagen opcional 2',
    //         'optional_image3' => 'imagen opcional 3',
    //         'optional_image4' => 'imagen opcional 4',

    //         'idattributes' => 'atributos',
    //         'idspecificattributes' => 'atributos específicos',
    //         'iduses' => 'usos',
    //         'idspecificuses' => 'usos especificos',

    //         'idcointype' => 'tipo de moneda',
    //         'idcategory' => 'categoría',
    //         'idsubcategory' => 'subcategoría',
    //         'idspecificsubcategory' => 'subcategoría especifica',
    //         'idtype' => 'tipo de producto',
    //         'idsupplier' => 'proveedor',

    //         'idunitmeasure' => 'unidad de medida',
    //         'idunitmeasureoptional' => 'unidad de medida opcional',
    //         'idbusinessarea' => 'área de negocio',
    //         'idclassification' => 'clasificación',
    //         'idcompany' => 'compañia',
    //     ];
    // }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
