<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ProductRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'code_erp' => ['nullable', 'string', 'max:100', 'required_without:code_system'],
            'code_system' => ['nullable', 'string', 'max:100', 'required_without:code_erp'],
            'barcode' => ['nullable', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:255'],
            'cost' => ['nullable', 'numeric'],
            'price' => ['nullable', 'numeric'],
            'alternativeprice' => ['nullable', 'numeric'],
            'margin' => ['nullable', 'numeric'],
            'offerprice' => ['nullable', 'numeric'],
            'minimumstock' => ['nullable', 'numeric'],
            'maximumstock' => ['nullable', 'numeric'],

            'main_image' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image1' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image2' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image3' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            'optional_image4' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],

            'idattributes' => ['nullable', 'string'],
            'idspecificattributes' => ['nullable', 'string'],
            'iduses' => ['nullable', 'string'],
            'idspecificuses' => ['nullable', 'string'],

            'idcointype' => ['required', 'numeric', 'validate_ids_exist:CoinType'],
            'idcategory' => ['required', 'numeric', 'validate_ids_exist:Category'],
            'idsubcategory' => ['nullable', 'validate_ids_exist:Subcategory'],
            'idspecificsubcategory' => ['nullable', 'validate_ids_exist:SpecificSubcategory'],
            'idtype' => ['required', 'numeric', 'validate_ids_exist:TypeProduct'],
            'idsupplier' => ['required', 'numeric', 'validate_ids_exist:Supplier'],

            'idunitmeasure' => ['required', 'numeric', 'validate_ids_exist:UnitMeasure'],
            'idunitmeasureoptional' => ['nullable', 'validate_ids_exist:UnitMeasure'],
            'idbusinessarea' => ['nullable', 'validate_ids_exist:BusinessArea'],
            'idclassification' => ['required', 'numeric', 'validate_ids_exist:ProductClassification'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
