<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class PriceListRequest extends FormRequest
{
    use HasResponse;
    
    public function authorize(): bool
    {
        return true;
    }

    
    public function rules(): array
    {
        return [
            'code' => ['required', 'string', 'max:11'],
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:255'],
            'validity_date' => ['nullable', 'string'],
            'document_state' => ['nullable', 'string'],
            'quantity_products' => ['required', 'numeric'],
            'total' => ['required', 'numeric'],
            'type' => ['required', 'string'],
            'discounttype' => ['required', 'string'],
            'max_desc_item' => ['nullable', 'numeric'],
            'max_desc_global' => ['nullable', 'numeric'],

            'products' => ['nullable', 'array'],
            'idbranchoffices' => ['nullable', 'array'],
            'idsalesman' => ['nullable', 'array'],
            'idsegments' => ['nullable', 'array'],
            'idcustomers' => ['nullable', 'array'],
            'price' => ['nullable', 'numeric'],
            'cost' => ['nullable', 'numeric'],
            'detailquantity' => ['nullable', 'numeric'],

            'status' => ['nullable', 'string', 'max:1'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
