<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class PermissionsUserRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = [
            'iduser'        => ['nullable', 'numeric'],
            'permissions'   => ['required', 'array'],
            'actions'       => ['nullable', 'array'],
            'actions.*'     => ['nullable', 'numeric', 'between:1,4'],
            'idcompany'     => ['nullable', 'numeric']
        ];

        if ($this->isMethod('POST')) {
            $rules['iduser']    = ['required', 'numeric'];
            $rules['actions']   = ['required', 'array'];
            $rules['actions.*'] = ['required', 'numeric', 'between:1,4'];
        }

        return $rules;
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
