<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class MembershipRequest extends FormRequest
{
    use HasResponse;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'          => ['required','string'],
            'view_pay'      => ['required','integer', 'in:0,1'],
            'url_redirect'  => ['required','string'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
