<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class MembershipCostRequest extends FormRequest
{
    use HasResponse;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'idplans'       => ['required','integer'],
            'idmembership'  => ['required','integer'],
            'amount'        => ['required','numeric'],
            'date_start'    => ['required','date'],
            'date_end'      => ['nullable','date'],
            'cod_erp'       => ['required','string']

        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
