<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class InitialStepRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = [
            'description'   => ['required', 'string', 'max:255'],
            'plans'         => ['nullable', 'array', 'min:1'],
            'plans.*'       => ['required', 'string', 'in:basic,standar,pro']
        ];

        if ($this->isMethod('PATCH')) {
            foreach ($rules as $field => &$rule) {
                $rule = array_diff($rule, ['required']);
                $rule[] = 'nullable';
            }
        }

        return $rules;
    }

    public function failedValidation(Validator $validator)
    {
        $errors = $validator->errors();
        $primerArray = reset($errors);
        $primerError = reset($primerArray);
        $message = $primerError[0];

        throw new HttpResponseException($this->errorResponse($message, 400));
    }
}
