<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class DetailMembershipPaymentRequest extends FormRequest
{
    use HasResponse;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'idmembershipcosts' => ['required', 'integer'],
            'idcompany'         => ['required', 'integer'],
            'idpay'             => ['required', 'integer'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
