<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class CustomerWalletRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'description' => ['required', 'string'],
            'idsupplier' => ['required', 'numeric', 'validate_ids_exist:Supplier'],
            'idsalesman' => ['required', 'numeric', 'validate_ids_exist:Salesman'],
            'idaccount_status' => ['required', 'numeric', 'validate_ids_exist:AccountStatus'],
            'relationship_date' => ['required', 'date'],
            'last_purchase' => ['required', 'date'],
            'goal' => ['required', 'string'],
            'idbranchoffice' => ['required', 'numeric', 'validate_ids_exist:BranchOffice'],
            'idcompany' => ['required', 'numeric', 'validate_ids_exist:Company'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
