<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class CompanyConfigurationRequest extends FormRequest
{
    use HasResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'inventory_configuration'   => ['required', 'integer'],
            'credit_terms'              => ['nullable', 'array'],
            'credit_terms.*'            => ['required_with:credit_terms', 'integer'],
            'cash_options'              => ['nullable', 'array'],
            'cash_options.*'            => ['required_with:cash_options', 'integer','validate_ids_exist:CashPaymentMethods'],
            'payment_validation'        => ['nullable', 'in:1,2'],
            'idcompany'                 => ['required', 'integer']
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
