<?php

namespace App\Http\Requests;

use App\Traits\HasResponse;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class BranchOfficeRequest extends FormRequest
{
    use HasResponse;
    
    public function authorize(): bool
    {
        return true;
    }

    
    public function rules(): array
    {
        return [
            'code' => ['nullable', 'string', 'max:11'],
            'name' => ['required', 'string', 'max:255'],
            'address' => ['required', 'string', 'max:150'],
            'phone' => ['required', 'string', 'max:20'],
            // 'assignmenttype' => ['required', 'string', 'max:1'],

            // 'idproductlist' => ['nullable', 'numeric'],
            'idofficetype' => ['required', 'numeric'],
            'idcountry' => ['required', 'numeric'],
            'iddepartment' => ['required', 'numeric'],
            'idprovince' => ['required', 'numeric'],
            'iddistrict' => ['required', 'numeric'],
            'idcompany' => ['required', 'numeric'],
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->errorResponse('Formato inválido.', 400, $validator->errors()));
    }
}
