<?php

namespace App\Http\Controllers;

use App\Http\Requests\WayToPayForCompanyRequest;
use App\Services\WayToPayService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class WayToPayController extends Controller
{
    use HasResponse;
    /** @var WayToPayService */
    private $wayToPayService;

    public function __construct(WayToPayService $wayToPayService)
    {
        $this->wayToPayService = $wayToPayService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->wayToPayService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->wayToPayService->listByCompany($request->all(), $withPagination);
    }

    public function listPaymentCuotas(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->wayToPayService->listPaymentCuotas($request->all(), $withPagination);
    }

    public function listPaymentTools(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->wayToPayService->listPaymentTools($request->all(), $withPagination);
    }

    public function assignPaymentMethod(WayToPayForCompanyRequest $request)
    {
        return $this->wayToPayService->assignPaymentMethod($request->validated());
    }

    public function updatePaymentAssignment($id, Request $request)
    {
        return $this->wayToPayService->updatePaymentAssignment($id, $request);
    }
}
