<?php

namespace App\Http\Controllers;

use App\Services\UserErpService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class UserErpController extends Controller
{
    use HasResponse;
    /** @var UserErpService */
    private $userErpService;

    public function __construct(UserErpService $userErpService)
    {
        $this->userErpService = $userErpService;
    }

    public function verify($iduser, Request $request){
       return $this->userErpService->verify($iduser, $request->all());
    }

    public function register(Request $request){
        return $this->userErpService->register($request->all());
    }

    public function update($id, Request $request){
        return $this->userErpService->update($id, $request->all());
    }

    public function delete($id){
        return $this->userErpService->delete($id);
    } 

}
