<?php

namespace App\Http\Controllers;

use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\ForgotPasswordRequest;
use App\Http\Requests\UserRequest;
use App\Services\UserService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class UserController extends Controller
{
    use HasResponse;
    /** @var UserService */
    private $userService;

    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }

    public function list(Request $request){
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->userService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->userService->listByCompany($request->all(), $withPagination);
    }

    public function register(UserRequest $request){
        return $this->userService->register($request->validated());
    }

    public function registerBySuperadmin(UserRequest $request){
        return $this->userService->registerBySuperadmin($request->all());
    }

    public function update($id, UserRequest $request){
        return $this->userService->update($id, $request->validated());
    }
    public function changeStatus($id, Request $request){
        return $this->userService->changeStatus($id, $request);
    }

    public function delete($id){
        return $this->userService->delete($id);
    }

    public function changePassword(ChangePasswordRequest $request){
        return $this->userService->changePassword($request->validated());
    }

    // public function forgotPassword(ForgotPasswordRequest $request){
    //     return $this->userService->forgotPassword($request->validated());
    // }

    public function listUserType(Request $request){
        return $this->userService->listUserType();
    }

    public function listPrivilege(Request $request){
        return $this->userService->listPrivilege();
    }
}
