<?php

namespace App\Http\Controllers;

use App\Http\Requests\UsageAttributeRequest;
use App\Services\UsageAttributeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class UsageAttributesController extends Controller
{
    use HasResponse;
    /** @var UsageAttributeService */
    private $usageAttributeService;

    public function __construct(UsageAttributeService $usageAttributeService)
    {
        $this->usageAttributeService = $usageAttributeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->usageAttributeService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->usageAttributeService->listByCompany($request->all(), $withPagination);
    }

    public function register(UsageAttributeRequest $request)
    {
        return $this->usageAttributeService->register($request->validated());
    }

    public function relationProducts($id, Request $request)
    {
        return  $this->usageAttributeService->relationProducts($id, $request);
    }

    public function update($id, UsageAttributeRequest $request)
    {
        return $this->usageAttributeService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->usageAttributeService->delete($id);
    }
}
