<?php

namespace App\Http\Controllers;

use App\Services\UbigeoService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class UbigeoController extends Controller
{
    use HasResponse;
    /** @var UbigeoService */
    private $ubigeoService;

    public function __construct(UbigeoService $ubigeoService)
    {
        $this->ubigeoService = $ubigeoService;
    }
    
    public function listCountries(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ubigeoService->listCountries($request->all(), $withPagination);
    }
    public function listDepartments(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ubigeoService->listDepartments($request->all(), $withPagination);
    }
    public function listProvinces(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ubigeoService->listProvinces($request->all(), $withPagination);
    }
    public function listDistricts(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ubigeoService->listDistricts($request->all(), $withPagination);
    }
}
