<?php

namespace App\Http\Controllers;

use App\Http\Requests\TypeSaleRequest;
use App\Services\TypeSaleService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class TypeSaleController extends Controller
{
    use HasResponse;

    /** @var TypeSaleService */
    private $typeSaleService;

    public function __construct(TypeSaleService $typeSaleService)
    {
        $this->typeSaleService = $typeSaleService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->typeSaleService->list($request->all(), $withPagination);
    }

    public function register(TypeSaleRequest $request)
    {
        $this->typeSaleService->register($request->validated());
    }

    public function update($id, TypeSaleRequest $request)
    {
        return $this->typeSaleService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->typeSaleService->delete($id);
    }
}
