<?php

namespace App\Http\Controllers;

use App\Http\Requests\TypeProductRequest;
use App\Services\TypeProductService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class TypeProductController extends Controller
{
    use HasResponse;
    
    /** @var TypeProductService */
    private $typeProductService;

    public function __construct(TypeProductService $typeProductService)
    {
        $this->typeProductService = $typeProductService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->typeProductService->list($request->all(), $withPagination);
    }

    public function register(TypeProductRequest $request)
    {
        return $this->typeProductService->register($request->validated());
    }

    public function update($id, TypeProductRequest $request)
    {
        return $this->typeProductService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->typeProductService->delete($id);
    }
}
