<?php

namespace App\Http\Controllers;

use App\Http\Requests\TypeAttributeRequest;
use App\Services\TypeAttributeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class TypeAttributeController extends Controller
{
    use HasResponse;
    /** @var TypeAttributeService */
    private $typeAttributeService;

    public function __construct(TypeAttributeService $typeAttributeService)
    {
        $this->typeAttributeService = $typeAttributeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->typeAttributeService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->typeAttributeService->listByCompany($request->all(), $withPagination);
    }

    public function register(TypeAttributeRequest $request)
    {
        return $this->typeAttributeService->register($request->validated());
    }

    public function update($id, TypeAttributeRequest $request)
    {
        return $this->typeAttributeService->update($id, $request->validated());
    }

    public function changeStatus($id, Request $request)
    {
        return $this->typeAttributeService->changeStatus($id, $request);
    }

    public function delete($id)
    {
        return $this->typeAttributeService->delete($id);
    }
}
