<?php

namespace App\Http\Controllers;

use App\Http\Requests\TranskbankCredentialsRequest;
use App\Http\Requests\TranskbankRequest;
use App\Services\TransbankService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class TransbankController extends Controller
{
    use HasResponse;

    /** @var TransbankService */
    private $transbankService;

    public function __construct(TransbankService $transbankService)
    {
        $this->transbankService = $transbankService;
    }

    public function startWebpayPlusTransaction($id, TranskbankRequest $request)
    {
        return $this->transbankService->startWebpayPlusTransaction($id, $request->validated());
    }

    public function confirmar_pago_wp(Request $request)
    {
        return $this->transbankService->confirmar_pago_wp($request->all());
    }

    public function assignCredentials(TranskbankCredentialsRequest $request)
    {
        return $this->transbankService->assignCredentials($request->validated());
    }

    public function payments(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->transbankService->payments($request->all(), $withPagination);
    }
}
