<?php

namespace App\Http\Controllers;

use App\Http\Requests\TicketRequest;
use App\Services\TicketService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    use HasResponse;

    /** @var TicketService */
    private $ticketService;

    public function __construct(TicketService $ticketService)
    {
        $this->ticketService = $ticketService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ticketService->list($withPagination);
    }

    public function salesBook(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->ticketService->salesBook($withPagination);
    }

    public function register(TicketRequest $request)
    {
        return $this->ticketService->register($request->validated());
    }

    public function delete($id)
    {
        return $this->ticketService->delete($id);
    }

    public function generateDocument(Request $request)
    {
        return $this->ticketService->generateDocument($request->all());
    }
}
