<?php

namespace App\Http\Controllers;

use App\Http\Requests\SupplierRequest;
use App\Services\SupplierService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SupplierController extends Controller
{
    use HasResponse;
    
    /** @var SupplierService */
    private $supplierService;

    public function __construct(SupplierService $supplierService)
    {
        $this->supplierService = $supplierService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->supplierService->list($request->all(), $withPagination);
    }

    public function register(SupplierRequest $request)
    {
        return $this->supplierService->register($request->validated());
    }

    public function update($id, SupplierRequest $request)
    {
        return $this->supplierService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->supplierService->delete($id);
    }
}
