<?php

namespace App\Http\Controllers;

use App\Http\Requests\SubcategoryRequest;
use App\Services\SubcategoryService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SubcategoryController extends Controller
{
    use HasResponse;
    /** @var SubcategoryService */
    private $subcategoryService;

    public function __construct(SubcategoryService $subcategoryService)
    {
        $this->subcategoryService = $subcategoryService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->listByCompany($request->all(), $withPagination);
    }

    public function listDuplicated(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->listDuplicated($request->all(), $withPagination);
    }

    public function reviewData(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->reviewData($request->all(), $withPagination);
    }

    public function listWithProducts(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->listWithProducts($request->all(), $withPagination);
    }

    public function listByCategory(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->subcategoryService->listByCategory($request->all(), $withPagination);
    }

    public function register(SubcategoryRequest $request)
    {
        return $this->subcategoryService->register($request->validated());
    }

    public function unifyDuplicated(Request $request)
    {
        return $this->subcategoryService->unifyDuplicated($request->all());
    }

    public function update($id, SubcategoryRequest $request)
    {
        return $this->subcategoryService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->subcategoryService->delete($id);
    }
}
