<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreRequest;
use App\Services\StoreService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class StoreController extends Controller
{
    use HasResponse;
    /** @var StoreService */
    private $storeService;

    public function __construct(StoreService $storeService)
    {
        $this->storeService = $storeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->storeService->list($request->all(), $withPagination);
    }

    public function register(StoreRequest $request)
    {
        return $this->storeService->register($request->validated());
    }

    public function update($id, StoreRequest $request)
    {
        return $this->storeService->update($id, $request->validated());
    }

    public function changeStatus($id, Request $request)
    {
        return $this->storeService->changeStatus($id, $request);
    }

    public function delete($id)
    {
        return $this->storeService->delete($id);
    }
}
