<?php

namespace App\Http\Controllers;

use App\Http\Requests\ReduceStockRequest;
use App\Http\Requests\StockProductRequest;
use App\Services\StockProductService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class StockProductController extends Controller
{
    use HasResponse;
    /** @var StockProductService */
    private $stockProductService;

    public function __construct(StockProductService $stockProductService)
    {
        $this->stockProductService = $stockProductService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->stockProductService->list($withPagination);
    }

    public function register(StockProductRequest $request)
    {
        return $this->stockProductService->register($request->validated());
    }

    public function update($id, StockProductRequest $request)
    {
        return $this->stockProductService->update($id, $request->validated());
    }

    public function searchProductAvailability(Request $request)
    {
        return $this->stockProductService->searchProductAvailability($request);
    }

    public function delete($id)
    {
        return $this->stockProductService->delete($id);
    }

    public function reduceStock(ReduceStockRequest $request)
    {
        return $this->stockProductService->reduceStock($request->validated());

    }
}
