<?php

namespace App\Http\Controllers;

use App\Http\Requests\SpecificUseRequest;
use App\Services\SpecificUsesService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SpecificUsesController extends Controller
{
    use HasResponse;
    /** @var SpecificUsesService */
    private $specificUsesService;

    public function __construct(SpecificUsesService $specificUsesService)
    {
        $this->specificUsesService = $specificUsesService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificUsesService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificUsesService->listByCompany($request->all(), $withPagination);
    }

    public function listByUse(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificUsesService->listByUse($request->all(), $withPagination);
    }

    public function register(SpecificUseRequest $request)
    {
        return $this->specificUsesService->register($request->validated());
    }

    public function update($id, SpecificUseRequest $request)
    {
        return $this->specificUsesService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->specificUsesService->delete($id);
    }
}
