<?php

namespace App\Http\Controllers;

use App\Http\Requests\SpecificSubcategoryRequest;
use App\Services\SpecificSubcategoryService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SpecificSubcategoryController extends Controller
{
    use HasResponse;
    /** @var SpecificSubcategoryService */
    private $specificSubcategoryService;

    public function __construct(SpecificSubcategoryService $specificSubcategoryService)
    {
        $this->specificSubcategoryService = $specificSubcategoryService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificSubcategoryService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificSubcategoryService->listByCompany($request->all(), $withPagination);
    }

    public function listBySubcategory(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificSubcategoryService->listBySubcategory($request->all(), $withPagination);
    }

    public function register(SpecificSubcategoryRequest $request)
    {
        return $this->specificSubcategoryService->register($request->validated());
    }

    public function update($id, SpecificSubcategoryRequest $request)
    {
        return $this->specificSubcategoryService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->specificSubcategoryService->delete($id);
    }
}
