<?php

namespace App\Http\Controllers;

use App\Http\Requests\SpecificAttributeRequest;
use App\Services\SpecificAttributeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SpecificAttributesController extends Controller
{
    use HasResponse;
    /** @var SpecificAttributeService */
    private $specificAttributeService;

    public function __construct(SpecificAttributeService $specificAttributeService)
    {
        $this->specificAttributeService = $specificAttributeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificAttributeService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificAttributeService->listByCompany($request->all(), $withPagination);
    }

    public function listByAttribute(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->specificAttributeService->listByAttribute($request->all(), $withPagination);
    }

    public function register(SpecificAttributeRequest $request)
    {
        return $this->specificAttributeService->register($request->validated());
    }

    public function update($id, SpecificAttributeRequest $request)
    {
        return $this->specificAttributeService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->specificAttributeService->delete($id);
    }
}
