<?php

namespace App\Http\Controllers;

use App\Services\SoftnetService;
use Illuminate\Http\Request;

class SoftnetController extends Controller
{
    /** @var SoftnetService */
    private $softnetService;

    public function __construct(SoftnetService $softnetService)
    {
        $this->softnetService = $softnetService;
    }

    public function getFormaPagoERP()
    {
        return $this->softnetService->getFormaPagoERP();
    }

    public function importFormaPago()
    {
        return $this->softnetService->importFormaPago();
    }

    public function importSelectFormaPago(Request $request)
    {
        return $this->softnetService->importSelectFormaPago($request);
    }

    public function getAreaNegocio(Request $request)
    {
        return $this->softnetService->getAreaNegocio($request);
    }

    public function getVendedor(Request $request)
    {
        return $this->softnetService->getVendedor($request);
    }

    public function getWareHouseERP()
    {
        return $this->softnetService->getWareHouseERP();
    }

    public function getBusinessAreaERP()
    {
        return $this->softnetService->getBusinessAreaERP();
    }

    public function getProductsERP()
    {
        return $this->softnetService->getProductsERP();
    }

    public function getCategoryERP()
    {
        return $this->softnetService->getCategoryERP();
    }

    public function getSubcategoryERP()
    {
        return $this->softnetService->getSubcategoryERP();
    }

    public function getSpecificSubcategoryERP()
    {
        return $this->softnetService->getSpecificSubcategoryERP();
    }

    public function getUserERP()
    {
        return $this->softnetService->getUserERP();
    }

    public function getCustomerERP()
    {
        return $this->softnetService->getCustomerERP();
    }

    public function getSupplierERP()
    {
        return $this->softnetService->getSupplierERP();
    }

    public function getBranchOfficeERP()
    {
        return $this->softnetService->getBranchOfficeERP();
    }

    public function importWarehouse(Request $request)
    {
        return $this->softnetService->importWarehouse($request);
    }

    public function importSelectWarehouse(Request $request)
    {
        return $this->softnetService->importSelectWarehouse($request);
    }

    public function importBusinessArea(Request $request)
    {
        return $this->softnetService->importBusinessArea($request);
    }

    public function importSelectBusinessArea(Request $request)
    {
        return $this->softnetService->importSelectBusinessArea($request);
    }

    public function importProducts(Request $request)
    {
        return $this->softnetService->importProducts($request);
    }

    public function importSelectProducts(Request $request)
    {
        return $this->softnetService->importSelectProducts($request);
    }

    public function importCategory(Request $request)
    {
        return $this->softnetService->importCategory($request);
    }

    public function importSelectCategory(Request $request)
    {
        return $this->softnetService->importSelectCategory($request);
    }

    public function importSubcategory(Request $request)
    {
        return $this->softnetService->importSubcategory($request);
    }

    public function importSelectSubcategory(Request $request)
    {
        return $this->softnetService->importSelectSubcategory($request);
    }

    public function importSpecificsubcategory(Request $request)
    {
        return $this->softnetService->importSpecificsubcategory($request);
    }

    public function importSelectSpecificsubcategory(Request $request)
    {
        return $this->softnetService->importSelectSpecificsubcategory($request);
    }

    public function importCustomer(Request $request)
    {
        return $this->softnetService->importCustomer($request->all());
    }

    public function importSelectCustomer(Request $request)
    {
        return $this->softnetService->importSelectCustomer($request);
    }

    public function importSupplier(Request $request)
    {
        return $this->softnetService->importSupplier($request);
    }

    public function importSelectSupplier(Request $request)
    {
        return $this->softnetService->importSelectSupplier($request);
    }

    public function importBranchOffice(Request $request)
    {
        return $this->softnetService->importBranchOffice($request);
    }

    public function importSelectBranchOffice(Request $request)
    {
        return $this->softnetService->importSelectBranchOffice($request);
    }

    public function issueTicket($id, Request $request)
    {
        return $this->softnetService->issueTicket($id, $request->all());
    }
}
