<?php

namespace App\Http\Controllers;

use App\Http\Requests\AssignShoppingCartRequest;
use App\Http\Requests\ShoppingCartRequest;
use App\Http\Requests\ShoppingCartUpdateRequest;
use App\Services\ShoppingCartService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ShoppingCartController extends Controller
{
    use HasResponse;
    /** @var ShoppingCartService */
    private $shoppingCartService;

    public function __construct(ShoppingCartService $shoppingCartService)
    {
        $this->shoppingCartService = $shoppingCartService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->shoppingCartService->list($withPagination);
    }

    public function listCustomer($id, Request $request)
    {
        return $this->shoppingCartService->listCustomer($id, $request->all());
    }

    public function changeGlobalDiscount($id, Request $request)
    {
        return $this->shoppingCartService->changeGlobalDiscount($id, $request->all());
    }

    public function register(ShoppingCartRequest $request)
    {
        return $this->shoppingCartService->register($request->validated());
    }

    public function updateProduct($id, ShoppingCartUpdateRequest $request)
    {
        return $this->shoppingCartService->updateProduct($id, $request->validated());
    }

    public function deleteProduct($id)
    {
        return $this->shoppingCartService->deleteProduct($id);
    }

    public function assignCustomer($id, AssignShoppingCartRequest $request)
    {
        return $this->shoppingCartService->assignCustomer($id, $request->validated());
    }
}
