<?php

namespace App\Http\Controllers;

use App\Http\Requests\SegmentRequest;
use App\Services\SegmentService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SegmentController extends Controller
{
    use HasResponse;

    /** @var SegmentService */
    private $segmentService;

    public function __construct(SegmentService $segmentService)
    {
        $this->segmentService = $segmentService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->segmentService->list($request->all(), $withPagination);
    }

    public function register(SegmentRequest $request)
    {
        return $this->segmentService->register($request->validated());
    }

    public function update($id, SegmentRequest $request)
    {
        return $this->segmentService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->segmentService->delete($id);
    }
}
