<?php

namespace App\Http\Controllers;

use App\Http\Requests\SalesmanRequest;
use App\Services\SalesmanService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SalesmanController extends Controller
{
    use HasResponse;
    /** @var SalesmanService */
    private $salesmanService;

    public function __construct(SalesmanService $salesmanService)
    {
        $this->salesmanService = $salesmanService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->salesmanService->list($withPagination);
    }

    public function register(SalesmanRequest $request)
    {
        return $this->salesmanService->register($request->validated());
    }

    public function update($id, SalesmanRequest $request)
    {
        return $this->salesmanService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->salesmanService->delete($id);
    }
}
